var SwitchoverFormTemplateEditConditionModalCtrl = (function () {
    function SwitchoverFormTemplateEditConditionModalCtrl($rootScope, $scope, $modal, $modalService, authentication, language, switchoverFormConfigurationProvider, notificationService, switchoverFormsCkeditorConfigurationProvider, removeHtmlFilter, condition, conditions, isEditable, isTypical) {
        var _this = this;
        var _a;
        this.$rootScope = $rootScope;
        this.$scope = $scope;
        this.$modal = $modal;
        this.$modalService = $modalService;
        this.authentication = authentication;
        this.language = language;
        this.switchoverFormConfigurationProvider = switchoverFormConfigurationProvider;
        this.notificationService = notificationService;
        this.switchoverFormsCkeditorConfigurationProvider = switchoverFormsCkeditorConfigurationProvider;
        this.removeHtmlFilter = removeHtmlFilter;
        this.condition = condition;
        this.conditions = conditions;
        this.isEditable = isEditable;
        this.isTypical = isTypical;
        this.conditionTypes = [
            {
                id: 1,
                name: this.language.getElementValue('switchoverFormsAutomaticTypeMsg'),
            },
            {
                id: 0,
                name: this.language.getElementValue('switchoverFormsManualTypeMsg'),
            },
            { id: 2, name: this.language.getElementValue('switchoverFormsTextTypeMsg') },
        ];
        this.commandSources = [
            { id: 1, name: this.language.getElementValue('winccoaHdr') },
            { id: 0, name: this.language.getElementValue('opcSourceHdr') },
        ];
        this.commandTypes = [
            {
                id: 0,
                name: this.language.getElementValue('switchoverFormsCommandTypeVerifyMsg'),
            },
            {
                id: 1,
                name: this.language.getElementValue('switchoverFormsCommandTypeWriteMsg'),
            },
            {
                id: 2,
                name: this.language.getElementValue('switchoverFormsCommandTypeVerifyBitMsg'),
            },
            {
                id: 3,
                name: this.language.getElementValue('switchoverFormsCommandTypeWriteBitMsg'),
            },
        ];
        this.opcConnectionGuid = '';
        this.winccOaConnectionGuid = '';
        this.$scope.ctrl = this;
        if (_.isUndefined(this.condition)) {
            this.condition = {
                id: 0,
                description: this.getDescription(this.language.getElementValue('switchoverFormConditionHdr'), (((_a = this.conditions) === null || _a === void 0 ? void 0 : _a.length) + 1)),
                type: 0,
                isTypical: true,
                commands: [],
            };
        }
        this.selectedCondition = angular.copy(this.condition);
        this.selectedCondition.commands = _.sortBy(this.selectedCondition.commands, function (c) { return c.orderNumber; });
        this.editorConfiguration = this.switchoverFormsCkeditorConfigurationProvider.getStepFullEditorConfiguration();
        this.editorConfiguration.config.readOnly = !this.isEditable;
        this.switchoverFormConfigurationProvider
            .getSwitchoverFormConfiguration()
            .then(function (data) {
            _this.opcConnectionGuid = data.opcConnectionGuid;
            _this.winccOaConnectionGuid = data.winccOaConnectionGuid;
        })
            .catch(function (result) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), result);
        });
    }
    SwitchoverFormTemplateEditConditionModalCtrl.prototype.isAutomatic = function () {
        return this.selectedCondition.type === 1;
    };
    SwitchoverFormTemplateEditConditionModalCtrl.prototype.ok = function () {
        var _this = this;
        if (!this.isValid()) {
            this.notificationService.warnMessage(this.language.getElementValue('switchoverFormsErrorAllFieldsMustBeFilledMsg'));
            return;
        }
        var pureDescription = this.removeHtmlFilter(this.selectedCondition.description);
        var duplicate = this.isTypical ? _.find(this.conditions, function (condition) { return _this.removeHtmlFilter(condition.description) === pureDescription; }) : undefined;
        if (_.isDefined(duplicate)) {
            this.$modalService
                .open({
                templateUrl: 'ng1/dist/src/Common/Components/YesNoModal.html',
                controller: 'yesNoModalCtrl',
                backdrop: 'static',
                resolve: {
                    header: function () { return _this.language.getElementValue('switchoverFormsConditionExistsHdr'); },
                    body: function () { return _this.language.getElementValue('switchoverFormsConditionExistsMsg'); },
                },
            })
                .result.then(function () {
                if (_this.selectedCondition.type !== 1) {
                    _this.selectedCondition.commands = [];
                }
                _this.$modal.close(_this.selectedCondition);
            }, function () { });
        }
        else {
            if (this.selectedCondition.type !== 1) {
                this.selectedCondition.commands = [];
            }
            this.$modal.close(this.selectedCondition);
        }
    };
    SwitchoverFormTemplateEditConditionModalCtrl.prototype.cancel = function () {
        this.$modal.dismiss();
    };
    SwitchoverFormTemplateEditConditionModalCtrl.prototype.selectTag = function (command) {
        var tagTreeTypes = command.source === 0
            ? [TagTreeType.Opc]
            : [TagTreeType.WinccOaCns, TagTreeType.WinccOaPara];
        var connectionGuid = command.source === 0
            ? this.opcConnectionGuid
            : this.winccOaConnectionGuid;
        var modalInstance = this.$modalService.open({
            templateUrl: 'ng1/dist/src/TagsTree/TagsTreeModal.html',
            controller: 'tagsTreeModalCtrl',
            windowClass: 'app-modal-window modal-wide modal-width-100 modal-tab-window level-two',
            backdrop: 'static',
            resolve: {
                connectionGuid: function () { return connectionGuid; },
                isMultiselectEnabled: function () { return false; },
                tagTreeTypes: function () { return tagTreeTypes; },
                tagAddress: function () { return command.tagAddress; },
            },
        });
        modalInstance.result.then(function (tags) {
            command.name = tags[0].name;
            command.tagAddress = tags[0].address;
            command.type = command.source === 1 && command.tagAddress.contains('_CMD')
                ? 1
                : 0;
        });
    };
    SwitchoverFormTemplateEditConditionModalCtrl.prototype.isWinccOaSource = function (commandSource) {
        return commandSource === 1;
    };
    SwitchoverFormTemplateEditConditionModalCtrl.prototype.isTagExists = function (command) {
        var _this = this;
        this.switchoverFormConfigurationProvider
            .isTagExists(command.tagAddress, command.source)
            .then(function (isTagExists) {
            if (isTagExists) {
                _this.notificationService.showMessage(_this.language.getElementValue('tagAddressIsExistMsg'));
            }
            else {
                _this.notificationService.errorMessage(_this.language.getElementValue('tagAddressIsNotExistMsg'));
            }
        })
            .catch(function (result) {
            _this.notificationService.errorMessage(_this.language.getElementValue('errorCheckTagAddressMsg'), result);
        });
    };
    SwitchoverFormTemplateEditConditionModalCtrl.prototype.isBitCommandType = function (command) {
        return (command.type === 2 ||
            command.type === 3);
    };
    SwitchoverFormTemplateEditConditionModalCtrl.prototype.onChangeBitInfo = function (command) {
        command.value = command.bitNumber + ';' + command.bitValue;
    };
    SwitchoverFormTemplateEditConditionModalCtrl.prototype.onChangeCommandType = function (command) {
        if (this.isBitCommandType(command)) {
            command.value = command.bitNumber + ';' + command.bitValue;
        }
        else {
            command.value = '1';
        }
    };
    SwitchoverFormTemplateEditConditionModalCtrl.prototype.insert = function () {
        var _this = this;
        var source = !_.isEmpty(this.winccOaConnectionGuid)
            ? 1
            : 0;
        var tagTreeTypes = source === 1
            ? [TagTreeType.WinccOaCns, TagTreeType.WinccOaPara]
            : [TagTreeType.Opc];
        var connectionGuid = source === 1
            ? this.winccOaConnectionGuid
            : this.opcConnectionGuid;
        var modalInstance = this.$modalService.open({
            templateUrl: 'ng1/dist/src/TagsTree/TagsTreeModal.html',
            controller: 'tagsTreeModalCtrl',
            windowClass: 'app-modal-window modal-wide modal-width-100 modal-tab-window level-two',
            backdrop: 'static',
            resolve: {
                connectionGuid: function () { return connectionGuid; },
                isMultiselectEnabled: function () { return true; },
                tagTreeTypes: function () { return tagTreeTypes; },
                tagAddress: function () { return undefined; },
            },
        });
        modalInstance.result.then(function (tags) {
            var _a;
            var orderNumber = _this.selectedCondition.commands.length === 0 ? 0 : _.last(_this.selectedCondition.commands).orderNumber + 1;
            var commands = _.map(tags, function (tag, index) {
                return {
                    id: 0,
                    name: tag.name,
                    type: source === 1 && tag.address.contains('_CMD')
                        ? 1
                        : 0,
                    source: source,
                    orderNumber: orderNumber + index,
                    tagAddress: tag.address,
                    value: '1',
                    switchoverFormCommonConditionId: _this.condition.id,
                    bitValue: 0,
                    bitNumber: 0,
                };
            });
            (_a = _this.selectedCondition.commands).push.apply(_a, commands);
            _this.selectedCondition.type = 1;
        });
    };
    SwitchoverFormTemplateEditConditionModalCtrl.prototype.refreshDescription = function () {
        var commandNames = _.map(this.selectedCondition.commands, function (command) { return command.name.length > 0 && command.name[0] === '.'
            ? command.name.split(/[:.]+/).pop()
            : command.name; });
        var commandRows = _.map(commandNames, function (commandName) {
            var commandNameParts = commandName.split('|');
            if (commandNameParts.length > 2) {
                commandNameParts = [commandNameParts[0].trim(), _.rest(commandNameParts, 1).join('|').trim()];
            }
            var commandNameIndex = commandNameParts.length === 1 ? 0 : 1;
            _.forEach(replaceCommandDescriptionDictionary, function (replacement) {
                if (commandName.trim().toLowerCase().endsWith(replacement.from.toLowerCase())) {
                    commandNameParts[commandNameIndex] = "".concat(replacement.to, " ").concat(commandNameParts[commandNameIndex].substring(0, commandNameParts[commandNameIndex].toLowerCase().lastIndexOf(replacement.from.toLowerCase())));
                }
            });
            var getColumnStyle = function (width) { return "width: ".concat(width, "px; border: none; padding: 0; text-align: left"); };
            var row = commandNameParts.length === 1
                ? "<td style=\"".concat(getColumnStyle(200), "\"></td><td style=\"").concat(getColumnStyle(700), "\">").concat(commandNameParts[0], "</td>")
                : "<td style=\"".concat(getColumnStyle(200), "\">").concat(commandNameParts[0], "</td><td style=\"").concat(getColumnStyle(700), "\">").concat(commandNameParts[1], "</td>");
            return "<tr>".concat(row, "</tr>");
        }).join('');
        this.selectedCondition.description = "<table style=\"width: 100%; border: none\"><tbody><tr>".concat(commandRows, "</tr></tbody></table>");
    };
    SwitchoverFormTemplateEditConditionModalCtrl.prototype.remove = function (index) {
        if (!this.canEditCommands()) {
            return;
        }
        this.selectedCondition.commands.splice(index, 1);
        for (var i = index; i < this.selectedCondition.commands.length; i++) {
            this.selectedCondition.commands[i].orderNumber = i;
        }
    };
    SwitchoverFormTemplateEditConditionModalCtrl.prototype.moveUp = function (index) {
        if (index == 0 || !this.canEditCommands()) {
            return;
        }
        this.selectedCondition.commands[index].orderNumber--;
        this.selectedCondition.commands[index - 1].orderNumber++;
        this.selectedCondition.commands.splice(index - 1, 0, this.selectedCondition.commands[index]);
        this.selectedCondition.commands.splice(index + 1, 1);
    };
    SwitchoverFormTemplateEditConditionModalCtrl.prototype.moveDown = function (index) {
        if (index === this.selectedCondition.commands.length - 1 || !this.canEditCommands()) {
            return;
        }
        this.selectedCondition.commands[index].orderNumber++;
        this.selectedCondition.commands[index + 1].orderNumber--;
        this.selectedCondition.commands.splice(index + 2, 0, this.selectedCondition.commands[index]);
        this.selectedCondition.commands.splice(index, 1);
    };
    SwitchoverFormTemplateEditConditionModalCtrl.prototype.isValid = function () {
        if (_.isUndefined(this.selectedCondition)) {
            return false;
        }
        var conditionNameHTML = this.selectedCondition.description.replace(/\s+/g, ' ').trim();
        var conditionNameWithoutHTML = this.removeHtmlFilter(conditionNameHTML);
        if (conditionNameWithoutHTML === '') {
            return false;
        }
        if (_.any(this.selectedCondition.commands, function (command) {
            return command.tagAddress === '' ||
                command.value === '' ||
                _.isUndefined(command.tagAddress) ||
                _.isUndefined(command.value);
        })) {
            return false;
        }
        if (this.selectedCondition.type === 1 &&
            this.selectedCondition.commands.length === 0) {
            return false;
        }
        return true;
    };
    SwitchoverFormTemplateEditConditionModalCtrl.prototype.canEditCommands = function () {
        return this.authentication.hasPermission(this.$rootScope.permissions.SwitchoverFormTemplateCommandEdit);
    };
    SwitchoverFormTemplateEditConditionModalCtrl.prototype.getDescription = function (descriptionName, orderNumber) {
        var getColumnStyle = function (width) { return "width: ".concat(width, "px; border: none; padding: 0; text-align: left"); };
        var location = this.language.getElementValue('switchoverFormsCommandCpuHdr');
        var name = descriptionName + ' ' + orderNumber.toString();
        return '<table style="width: 100%; border: none">\n' +
            '   <tbody>\n' +
            '       <tr>\n' +
            "           <td style=\"".concat(getColumnStyle(200), "\">").concat(location, "</td>\n") +
            "           <td style=\"".concat(getColumnStyle(700), "\">").concat(name, "</td>\n") +
            '       </tr>\n' +
            '   </tbody>\n' +
            '</table>';
    };
    SwitchoverFormTemplateEditConditionModalCtrl.$inject = [
        '$rootScope',
        '$scope',
        '$modalInstance',
        '$modal',
        'authentication',
        'language',
        'switchoverFormConfigurationProvider',
        'notificationService',
        'switchoverFormsCkeditorConfigurationProvider',
        'removeHtmlFilter',
        'condition',
        'conditions',
        'isEditable',
        'isTypical'
    ];
    return SwitchoverFormTemplateEditConditionModalCtrl;
}());
angular
    .module('kamhpp')
    .controller('SwitchoverFormTemplateEditConditionModalCtrl', SwitchoverFormTemplateEditConditionModalCtrl);
