var HomeCtrl = (function () {
    function HomeCtrl(upload, modal, operationTimeParameterProvider, switchoverFormProvider, switchoverFormTemplateProvider, licenseModuleService, authentication, permissionService, notificationService, language, coreConfiguration) {
        var _this = this;
        this.upload = upload;
        this.modal = modal;
        this.operationTimeParameterProvider = operationTimeParameterProvider;
        this.switchoverFormProvider = switchoverFormProvider;
        this.switchoverFormTemplateProvider = switchoverFormTemplateProvider;
        this.licenseModuleService = licenseModuleService;
        this.authentication = authentication;
        this.permissionService = permissionService;
        this.notificationService = notificationService;
        this.language = language;
        this.coreConfiguration = coreConfiguration;
        this.operationTimeParameters = [];
        this.switchoverFormInfos = [];
        this.switchoverFormLimit = 8;
        this.permissions = this.permissionService.getAll();
        this.licenseModuleService
            .getModulesInfo()
            .then(function (moduleInfo) {
            _this.isReportsModuleAvailable = moduleInfo.isReportModuleAvailable;
            _this.isOperationTimeModuleAvailable = moduleInfo.isOperationTimeModuleAvailable;
            if (_this.isOperationTimeModuleAvailable) {
                _this.operationTimeParameterProvider
                    .getAllNames()
                    .then(function (operationTimeParameters) {
                    _this.operationTimeParameters = operationTimeParameters;
                });
            }
            _this.isSwitchoverFormModuleAvailable = moduleInfo.isSwitchoverFormsModuleAvailable;
            if (_this.isSwitchoverFormModuleAvailable) {
                _this.loadSwitchoverFormInfo();
            }
        });
    }
    HomeCtrl.prototype.hasReportAdminPermission = function () {
        return this.authentication.hasPermission(this.permissions.ReportAdministrate);
    };
    HomeCtrl.prototype.hasOperationTimeAdminPermission = function () {
        return this.authentication.hasPermission(this.permissions.OperationTimeAdmin);
    };
    HomeCtrl.prototype.hasSwitchoverFormAdminPermission = function () {
        return this.authentication.hasPermission(this.permissions.SwitchoverFormTemplateAdmin);
    };
    HomeCtrl.prototype.importSwitchoverFormTemplates = function () {
        var _this = this;
        this.modal
            .open({
            templateUrl: 'ng1/dist/src/SwitchoverForms/Template/ImportTemplateModal/SwitchoverFormTemplateImportModal.html',
            controller: 'switchoverFormTemplateImportModalCtrl',
            backdrop: 'static',
            resolve: {
                chapters: function () { return []; },
            },
        })
            .result.then(function (uploadData) {
            _this.upload
                .upload(uploadData)
                .success(function () { return _this.loadSwitchoverFormInfo(); })
                .error(function (errorInfo) {
                _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorTemplatesImportMsg'), errorInfo);
            });
        }, function () { });
    };
    HomeCtrl.prototype.loadSwitchoverFormInfo = function () {
        var _this = this;
        if (this.isSwitchoverFormModuleAvailable) {
            this.switchoverFormTemplateProvider
                .getAllSwitchoverFormTemplatesShortInfo()
                .then(function (templates) {
                _this.isSwitchoverFormTemplatesExists = _.any(templates);
            });
            var now = new Date();
            var switchoverFormFilter = angular.copy({
                name: null,
                serialNumber: null,
                startDate: new Date(now.getFullYear(), 0, 1),
                endDate: now,
                isOpened: true,
                isClosed: true,
                isStopped: true,
            });
            this.switchoverFormProvider
                .getSwitchoverFormsInfo(switchoverFormFilter)
                .then(function (switchoverFormInfos) {
                _this.switchoverFormInfos = switchoverFormInfos;
            });
        }
    };
    HomeCtrl.$inject = [
        '$upload',
        '$modal',
        'operationTimeParameterProvider',
        'switchoverFormProvider',
        'switchoverFormTemplateProvider',
        'licenseService',
        'authentication',
        'permissionService',
        'notificationService',
        'language',
        'coreConfiguration',
    ];
    return HomeCtrl;
}());
angular.module('kamhpp').controller('HomeCtrl', HomeCtrl);
