var DeviceLimitExceedWindowController = (function () {
    function DeviceLimitExceedWindowController($scope, $location, $modalInstance, language, notificationService, userSessionProvider, coreConfigurationProvider, authentication, dateFilter) {
        this.$scope = $scope;
        this.$location = $location;
        this.$modalInstance = $modalInstance;
        this.language = language;
        this.notificationService = notificationService;
        this.userSessionProvider = userSessionProvider;
        this.coreConfigurationProvider = coreConfigurationProvider;
        this.authentication = authentication;
        this.dateFilter = dateFilter;
        this.bodyMessage = this.language.getElementValue('tryReconnectLaterMsg');
        this.$scope.ctrl = this;
    }
    DeviceLimitExceedWindowController.prototype.reconnect = function () {
        var _this = this;
        var request = this.authentication.isLoggedIn()
            ? this.userSessionProvider.updateUserSession(this.$location.url(), this.$location.url())
            : this.coreConfigurationProvider.getVersion();
        request.then(function () { return _this.$modalInstance.close(); }, function (error) {
            _this.bodyMessage = String.Format(_this.language.getElementValue('reconnectFailedMsg'), _this.dateFilter(new Date(), Date.masks.shortDateTime)) + '<br>' + _this.language.getElementValue('tryReconnectLaterMsg');
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    DeviceLimitExceedWindowController.$inject = [
        '$scope',
        '$location',
        '$modalInstance',
        'language',
        'notificationService',
        'userSessionProvider',
        'coreConfigurationProvider',
        'authentication',
        'dateFilter'
    ];
    return DeviceLimitExceedWindowController;
}());
angular.module('kamhpp').controller('deviceLimitExceedWindowController', DeviceLimitExceedWindowController);
