var utcDateAttribute = 'UTC';
Date.equals = function (a, b) {
    if (_.isUndefined(a) && _.isUndefined(b))
        return true;
    if ((_.isUndefined(a) && !_.isUndefined(b)) || (!_.isUndefined(a) && _.isUndefined(b)))
        return false;
    return a.compareTo(b) === 0;
};
Date.getNow = function () {
    return new Date();
};
Date.getYesterday = function () {
    var today = new Date();
    return today.addDays(-1).getBeginDay();
};
Date.getToday = function () {
    var today = new Date();
    return today.getBeginDay();
};
Date.getTomorrow = function () {
    var today = new Date();
    return today.addDays(1).getBeginDay();
};
Date.masks = {
    default: 'ddd mmm dd yyyy HH:MM:ss',
    shortDate: 'm/d/yy',
    mediumDate: 'mmm d, yyyy',
    shortDateWithPoint: 'dd.MM.yyyy',
    longDate: 'mmmm d, yyyy',
    fullDate: 'dddd, mmmm d, yyyy',
    shortTime: 'h:MM TT',
    mediumTime: 'h:MM:ss TT',
    longTime: 'h:MM:ss TT Z',
    isoDate: 'yyyy-mm-dd',
    isoTime: 'HH:MM:ss',
    isoDateTime: "yyyy-mm-dd'T'HH:MM:ss",
    isoUtcDateTime: "UTC:yyyy-mm-dd'T'HH:MM:ss'Z'",
    fullDateTime: 'dd.MM.yyyy HH:mm:ss',
    shortDateTime: 'HH:mm:ss',
};
Date.i18n = {
    dayNames: [
        'Вс',
        'Пн',
        'Вт',
        'Ср',
        'Чт',
        'Пт',
        'Сб',
        'Воскресенье',
        'Понедельник',
        'Вторник',
        'Среда',
        'Четверг',
        'Пятница',
        'Суббота',
    ],
    monthNames: [
        'Янв',
        'Фев',
        'Мар',
        'Апр',
        'Май',
        'Июн',
        'Июл',
        'Авг',
        'Сен',
        'Окт',
        'Ноя',
        'Дек',
        'Январь',
        'Февраль',
        'Март',
        'Апрель',
        'Май',
        'Июнь',
        'Июль',
        'Август',
        'Сентябрь',
        'Октябрь',
        'Ноябрь',
        'Декабрь',
    ],
};
Date.fromSMSExternalFormat = function (value) {
    var date = _.map(value.split('.'), function (item) {
        return parseInt(item);
    });
    return new Date(date[0], date[1] - 1, date[2], date[3], date[4], date[5]);
};
Date.isSMSExternalFormat = function (value) {
    var dateParts = value.split('.');
    if (dateParts.length !== 6 || !_.all(dateParts, function (item) { return /^\d+$/.test(item); })) {
        return false;
    }
    return (dateParts[0].length === 4 &&
        dateParts[1].length === 2 &&
        dateParts[2].length === 2 &&
        dateParts[3].length === 2 &&
        dateParts[4].length === 2 &&
        dateParts[5].length === 2);
};
Date.cultureinfo = {
    name: 'en-US',
    englishName: 'English (United States)',
    nativeName: 'English (United States)',
    dayNames: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
    abbreviatedDayNames: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
    shortestDayNames: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
    firstLetterDayNames: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
    monthNames: [
        'January',
        'February',
        'March',
        'April',
        'May',
        'June',
        'July',
        'August',
        'September',
        'October',
        'November',
        'December',
    ],
    abbreviatedMonthNames: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
    amDesignator: 'AM',
    pmDesignator: 'PM',
    firstDayOfWeek: 0,
    twoDigitYearMax: 2029,
    dateElementOrder: 'mdy',
    formatPatterns: {
        shortDate: 'M/d/yyyy',
        longDate: 'dddd, MMMM dd, yyyy',
        shortTime: 'h:mm tt',
        longTime: 'h:mm:ss tt',
        fullDateTime: 'dddd, MMMM dd, yyyy h:mm:ss tt',
        sortableDateTime: 'yyyy-MM-ddTHH:mm:ss',
        universalSortableDateTime: 'yyyy-MM-dd HH:mm:ssZ',
        rfc1123: 'ddd, dd MMM yyyy HH:mm:ss GMT',
        monthDay: 'MMMM dd',
        yearMonth: 'MMMM, yyyy',
    },
    regexPatterns: {
        jan: /^jan(uary)?/i,
        feb: /^feb(ruary)?/i,
        mar: /^mar(ch)?/i,
        apr: /^apr(il)?/i,
        may: /^may/i,
        jun: /^jun(e)?/i,
        jul: /^jul(y)?/i,
        aug: /^aug(ust)?/i,
        sep: /^sep(t(ember)?)?/i,
        oct: /^oct(ober)?/i,
        nov: /^nov(ember)?/i,
        dec: /^dec(ember)?/i,
        sun: /^su(n(day)?)?/i,
        mon: /^mo(n(day)?)?/i,
        tue: /^tu(e(s(day)?)?)?/i,
        wed: /^we(d(nesday)?)?/i,
        thu: /^th(u(r(s(day)?)?)?)?/i,
        fri: /^fr(i(day)?)?/i,
        sat: /^sa(t(urday)?)?/i,
        future: /^next/i,
        past: /^(last|past|prev(ious)?)/i,
        add: /^(\+|after|from)/i,
        subtract: /^(-|before|ago)/i,
        yesterday: /^yesterday/i,
        today: /^t(oday)?/i,
        tomorrow: /^tomorrow/i,
        now: /^n(ow)?/i,
        millisecond: /^(ms|milli(second)?s?)/i,
        second: /^sec(ond)?s?/i,
        minute: /^min(ute)?s?/i,
        hour: /^h(ou)?rs?/i,
        week: /^w(ee)?k/i,
        month: /^m(o(nth)?s?)?/i,
        day: /^d(ays?)?/i,
        year: /^y((ea)?rs?)?/i,
        shortMeridian: /^(a|p)/i,
        longMeridian: /^(a\.?m?\.?|p\.?m?\.?)/i,
        timezone: /^((e(s|d)t|c(s|d)t|m(s|d)t|p(s|d)t)|((gmt)?\s*(\+|-)\s*\d\d\d\d?)|gmt)/i,
        ordinalSuffix: /^\s*(st|nd|rd|th)/i,
        timeContext: /^\s*(:|a|p)/i,
    },
    abbreviatedTimeZoneStandard: { GMT: '-000', EST: '-0400', CST: '-0500', MST: '-0600', PST: '-0700' },
    abbreviatedTimeZoneDST: { GMT: '-000', EDT: '-0500', CDT: '-0600', MDT: '-0700', PDT: '-0800' },
};
Date.format = function (date, mask, utc) {
    var token = /d{1,4}|m{1,4}|yy(?:yy)?|([HhMsTt])\1?|[LloSZ]|"[^"]*"|'[^']*'/g, timezone = /\b(?:[PMCEA][SDP]T|(?:Pacific|Mountain|Central|Eastern|Atlantic) (?:Standard|Daylight|Prevailing) Time|(?:GMT|UTC)(?:[-+]\d{4})?)\b/g, timezoneClip = /[^-+\dA-Z]/g, pad = function (val, len) {
        val = String(val);
        len = len || 2;
        while (val.length < len)
            val = '0' + val;
        return val;
    };
    if (arguments.length == 1 && Object.prototype.toString.call(date) == '[object String]' && !/\d/.test(date)) {
        mask = date;
        date = undefined;
    }
    date = date ? new Date(date) : new Date();
    if (isNaN(date))
        throw SyntaxError('invalid date');
    mask = String(Date.masks[mask] || mask || Date.masks['default']);
    if (mask.slice(0, 4) == 'UTC:') {
        mask = mask.slice(4);
        utc = true;
    }
    var r = utc ? 'getUTC' : 'get', d = date[r + 'Date'](), day = date[r + 'Day'](), m = date[r + 'Month'](), y = date[r + 'FullYear'](), hours = date[r + 'Hours'](), minutes = date[r + 'Minutes'](), s = date[r + 'Seconds'](), milliseconds = date[r + 'Milliseconds'](), o = utc ? 0 : date.getTimezoneOffset(), flags = {
        d: d,
        dd: pad(d),
        ddd: Date.i18n.dayNames[day],
        dddd: Date.i18n.dayNames[day + 7],
        m: m + 1,
        mm: pad(m + 1),
        mmm: Date.i18n.monthNames[m],
        mmmm: Date.i18n.monthNames[m + 12],
        yy: String(y).slice(2),
        yyyy: y,
        h: hours % 12 || 12,
        hh: pad(hours % 12 || 12),
        H: hours,
        HH: pad(hours),
        M: minutes,
        MM: pad(minutes),
        s: s,
        ss: pad(s),
        l: pad(milliseconds, 3),
        L: pad(milliseconds > 99 ? Math.round(milliseconds / 10) : milliseconds),
        t: hours < 12 ? 'a' : 'p',
        tt: hours < 12 ? 'am' : 'pm',
        T: hours < 12 ? 'A' : 'P',
        TT: hours < 12 ? 'AM' : 'PM',
        Z: utc ? 'UTC' : (String(date).match(timezone) || ['']).pop().replace(timezoneClip, ''),
        o: (o > 0 ? '-' : '+') + pad(Math.floor(Math.abs(o) / 60) * 100 + (Math.abs(o) % 60), 4),
        S: ['th', 'st', 'nd', 'rd'][d % 10 > 3 ? 0 : (((d % 100) - (d % 10) != 10 ? 0 : 1) * d) % 10],
    };
    return mask.replace(token, function ($0) { return ($0 in flags ? flags[$0] : $0.slice(1, $0.length - 1)); });
};
Date.fromCString = function (value) {
    if (_.isDate(value)) {
        return value;
    }
    else {
        return new Date(parseInt(value.substr(6)));
    }
};
Date.fromCStringToLongString = function (value) {
    var date = Date.fromCString(value);
    return date.toLongString();
};
Date.fromStringDate = function (stringDateTime) {
    var dateTimeRegex = /^(\d{2})\.(\d{2})\.(\d{4}) (\d{2}):(\d{2}):(\d{2})$/;
    if (dateTimeRegex.test(stringDateTime)) {
        var dateTimeFromString = dateTimeRegex.exec(stringDateTime);
        return new Date(parseInt(dateTimeFromString[3]), parseInt(dateTimeFromString[2]) - 1, parseInt(dateTimeFromString[1]), parseInt(dateTimeFromString[4]), parseInt(dateTimeFromString[5]), parseInt(dateTimeFromString[6]));
    }
    return new Date(stringDateTime);
};
Date.isLeapYear = function (year) { return (year % 4 === 0 && year % 100 !== 0) || year % 400 === 0; };
Date.getDaysInMonth = function (year, month) {
    return [31, Date.isLeapYear(year) ? 29 : 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31][month];
};
Date.getLocalTimezoneUtcOffsetMinutes = function () {
    return new Date().getTimezoneOffset() * -1;
};
Date.getTimezoneOffsetMilliseconds = function () {
    return new Date().getTimezoneOffset() * 60 * 1000 * (-1);
};
Date.convertToUtc = function (localDate, timezoneOffsetMinutes) {
    if (timezoneOffsetMinutes === void 0) { timezoneOffsetMinutes = null; }
    var offsetMinutes = _.isDefined(timezoneOffsetMinutes)
        ? timezoneOffsetMinutes
        : Date.getLocalTimezoneUtcOffsetMinutes();
    return localDate.addMinutes(-1 * offsetMinutes);
};
Date.prototype.clone = function () {
    return new Date(this.getTime());
};
Date.prototype.compareTo = function (date) {
    if (isNaN(this)) {
        throw new Error(this);
    }
    return this > date ? 1 : this < date ? -1 : 0;
};
Date.prototype.equals = function (date) {
    return this.compareTo(date) === 0;
};
Date.prototype.getBeginYear = function () {
    return new Date(this.getFullYear(), 0, 1, 0, 0, 0, 0);
};
Date.prototype.getBeginMonth = function () {
    return new Date(this.getFullYear(), this.getMonth(), 1, 0, 0, 0, 0);
};
Date.prototype.getBeginWeek = function () {
    var beginDay = new Date(this.getFullYear(), this.getMonth(), this.getDate(), 0, 0, 0, 0);
    var day = beginDay.getDay(), diff = beginDay.getDate() - day + (day == 0 ? -6 : 1);
    return new Date(beginDay.setDate(diff));
};
Date.prototype.getBeginDay = function () {
    return new Date(this.getFullYear(), this.getMonth(), this.getDate(), 0, 0, 0, 0);
};
Date.prototype.getBeginHour = function () {
    return new Date(this.getFullYear(), this.getMonth(), this.getDate(), this.getHours(), 0, 0, 0);
};
Date.prototype.getEndDay = function () {
    return new Date(this.getFullYear(), this.getMonth(), this.getDate(), 23, 59, 59, 999);
};
Date.prototype.addMilliseconds = function (value) {
    this.setMilliseconds(this.getMilliseconds() + value);
    return this;
};
Date.prototype.addSeconds = function (value) {
    return this.addMilliseconds(value * 1000);
};
Date.prototype.addMinutes = function (value) {
    return this.addMilliseconds(value * 60000);
};
Date.prototype.addHours = function (value) {
    return this.addMilliseconds(value * 3600000);
};
Date.prototype.addDays = function (value) {
    return this.addMilliseconds(value * 86400000);
};
Date.prototype.addWeeks = function (value) {
    return this.addMilliseconds(value * 604800000);
};
Date.prototype.addMonths = function (value) {
    var n = this.getDate();
    this.setDate(1);
    this.setMonth(this.getMonth() + value);
    this.setDate(Math.min(n, this.getDaysInMonth()));
    return this;
};
Date.prototype.addYears = function (value) {
    return this.addMonths(value * 12);
};
Date.prototype.format = function (mask, utc) {
    return Date.format(this, mask, utc);
};
Date.prototype.toCString = function () {
    return '/Date(' + this.getTime() + ')/';
};
Date.prototype.toInitCDateTimeString = function () {
    return ('new DateTime(' +
        this.getFullYear() +
        ',' +
        (this.getMonth() + 1) +
        ',' +
        this.getDate() +
        ',' +
        this.getHours() +
        ',' +
        this.getMinutes() +
        ',' +
        this.getSeconds() +
        ')');
};
function pad(d) {
    return d < 10 ? '0' + d.toString() : d.toString();
}
Date.prototype.toShortString = function () {
    return pad(this.getDate()) + '.' + pad(this.getMonth() + 1) + '.' + pad(this.getFullYear());
};
Date.prototype.toLongString = function () {
    return (pad(this.getDate()) +
        '.' +
        pad(this.getMonth() + 1) +
        '.' +
        pad(this.getFullYear()) +
        ' ' +
        pad(this.getHours()) +
        ':' +
        pad(this.getMinutes()) +
        ':' +
        pad(this.getSeconds()));
};
Date.prototype.getDaysInMonth = function () {
    return Date.getDaysInMonth(this.getFullYear(), this.getMonth());
};
