var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var SmsCodeEditorCtrl = (function () {
    function SmsCodeEditorCtrl($element) {
        var _this = this;
        this.$element = $element;
        this.$onInit = function () {
            var _a;
            ace.config.set('basePath', '/assets/ace');
            _this.editor = ace.edit(_this.$element.context);
            var options = {
                theme: 'ace/theme/textmate',
                mode: "ace/mode/".concat((_a = _this.mode) !== null && _a !== void 0 ? _a : 'text'),
                fontSize: '1rem',
                enableBasicAutocompletion: true,
                enableLiveAutocompletion: true,
                enableSnippets: true,
                wrap: true,
                indentedSoftWrap: false,
            };
            _this.editor.setOptions(options);
            _this.editor.setShowPrintMargin(false);
            _this.editor.setValue(_this.value, 1);
            _this.editor.session.on('change', _this.onChange);
            if (_.isDefined(_this.completions)) {
                var getCompleter = function (completions) {
                    return {
                        getCompletions: function (editor, session, pos, prefix, callback) {
                            callback(null, completions);
                        },
                    };
                };
                var editor = _this.editor;
                editor.completers = editor.completers && editor.completers.length
                    ? __spreadArray(__spreadArray([], editor.completers, true), [getCompleter(_this.completions)], false) : [getCompleter(_this.completions)];
            }
            _this.onInit({ codeEditor: _this.editor });
        };
        this.onChange = function (delta) {
            _this.onChanged({ change: {
                    code: _this.editor.getValue(),
                    delta: delta
                } });
        };
    }
    SmsCodeEditorCtrl.prototype.$onChanges = function (onChangesObj) {
        if (_.isUndefined(this.editor)) {
            return;
        }
        var valueChange = onChangesObj['value'];
        var editorValue = this.editor.getValue();
        if (editorValue !== valueChange.currentValue) {
            this.editor.session.off('change', this.onChange);
            this.editor.setValue(valueChange.currentValue, 1);
            this.editor.session.on('change', this.onChange);
        }
    };
    SmsCodeEditorCtrl.prototype.$onDestroy = function () {
        var _a;
        (_a = this.editor) === null || _a === void 0 ? void 0 : _a.destroy();
    };
    SmsCodeEditorCtrl.$inject = ['$element'];
    return SmsCodeEditorCtrl;
}());
