app.controller('CimSettingsCtrl', function ($scope, clientSettings, notificationService, language, $upload, exportService) {
    var watchFunctions = [];
    $scope.files = [];
    $scope.export = function () {
        exportService.export('/CimModel/Export');
    };
    watchFunctions.push($scope.$watch('files', function () {
        $scope.import($scope.files);
    }));
    $scope.import = function (files) {
        if (files && files.length) {
            for (var i = 0; i < files.length; i++) {
                var file = files[i];
                $upload
                    .upload({
                    url: clientSettings.getServerInstance() + '/CimModel/Import',
                    file: file,
                })
                    .then(function (response) {
                    notificationService.showMessage(language.getElementValue('cimModelSuccessImportMsg'));
                    location.reload();
                }, function (response) {
                    notificationService.errorMessage(language.getElementValue('cimModelFailedImportMsg'), response.data);
                });
            }
        }
    };
    watchFunctions.push($scope.$on('$destroy', function () {
        for (var i = 0; i < watchFunctions.length; i++) {
            var func = watchFunctions[i];
            if (!_.isUndefined(func)) {
                func();
            }
        }
    }));
});
