var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var AdministrationCtrl = (function () {
    function AdministrationCtrl($scope, $modal, $location, $routeParams, authentication, permissionService, diagnosticService, language) {
        var _this = this;
        this.diagnosticService = diagnosticService;
        this.language = language;
        this.configurationTabs = [];
        this.diagnosticTabs = [];
        this.securityTabs = [];
        var permissions = permissionService.getAll();
        if (_.isBlank($routeParams.tab)) {
            $location.replace();
            $location.path($location.path() + 'configuration/core');
        }
        this.configurationTabs = [
            {
                name: 'core',
                ident: 'serverSettingsCoreHdr',
                url: '#/administration/configuration/core',
                isVisible: true
            },
            {
                name: 'authentication',
                ident: 'serverSettingAuthenticationHdr',
                url: '#/administration/security/authentication',
                isVisible: true
            },
            {
                name: 'mail',
                ident: 'serverSettingsMailClientHdr',
                url: '#/administration/settings/mail',
                isVisible: authentication.hasPermission(permissions.ReportAdministrate) ||
                    authentication.hasPermission(permissions.SwitchoverFormEdit)
            },
            {
                name: 'report',
                ident: 'reportsCpt',
                url: '#/administration/settings/report',
                isVisible: authentication.hasPermission(permissions.ReportAdministrate)
            },
            {
                name: 'switchover-form',
                ident: 'switchoverFormsHdr',
                url: '#/administration/settings/switchover-form',
                isVisible: authentication.hasPermission(permissions.SwitchoverFormEdit)
            },
            {
                name: 'operation-time',
                ident: 'operationTimeHdr',
                url: '#/administration/settings/operation-time',
                isVisible: authentication.hasPermission(permissions.OperationTimeAdmin)
            }
        ];
        this.diagnosticTabs = [
            {
                name: 'server',
                ident: 'diagnosticServerCpt',
                url: '#/administration/diagnostic/server',
                hasAppProblems: function () {
                    var _a, _b, _c, _d, _e;
                    return ((_a = diagnosticService.appWarningInfo) === null || _a === void 0 ? void 0 : _a.isFreeDriveSpaceOut) ||
                        ((_b = diagnosticService.appWarningInfo) === null || _b === void 0 ? void 0 : _b.isServerUnavailable) ||
                        ((_c = diagnosticService.appWarningInfo) === null || _c === void 0 ? void 0 : _c.isLicenseExpiring) ||
                        ((_d = diagnosticService.appWarningInfo) === null || _d === void 0 ? void 0 : _d.isPeriodicJobFailed) ||
                        ((_e = diagnosticService.appWarningInfo) === null || _e === void 0 ? void 0 : _e.isJobSchedulerDisabled);
                }
            },
            {
                name: 'database',
                ident: 'diagnosticDatabaseCpt',
                url: '#/administration/diagnostic/database',
                hasAppProblems: function () {
                    var _a, _b;
                    return ((_a = diagnosticService.appWarningInfo) === null || _a === void 0 ? void 0 : _a.isStandbyDatabaseUsed) ||
                        ((_b = diagnosticService.appWarningInfo) === null || _b === void 0 ? void 0 : _b.isDatabaseUnavailable);
                }
            },
            {
                name: 'mails-log',
                ident: 'mailsLogJournalOfSentLettersHdr',
                url: '#/administration/diagnostic/mails-log',
                hasAppProblems: function () { var _a; return (_a = diagnosticService.appWarningInfo) === null || _a === void 0 ? void 0 : _a.hasMailErrors; }
            },
            {
                name: 'sys-logs',
                ident: 'sysLogCpt',
                url: '#/administration/diagnostic/sys-logs',
                hasAppProblems: function () { return false; }
            },
        ];
        this.securityTabs = [
            {
                name: 'users',
                url: '#/administration/security/users',
                ident: 'usersHdr'
            },
            {
                name: 'roles',
                url: '#/administration/security/roles',
                ident: 'rolesHdr'
            },
        ];
        this.tabs = __spreadArray(__spreadArray(__spreadArray([], this.configurationTabs, true), this.securityTabs, true), this.diagnosticTabs, true);
        this.selectedTab = _.find(this.tabs, function (tab) { return tab.name == $routeParams.tab; });
        $scope.$on('$locationChangeStart', function (event) {
            if (_.isUndefined(_this.configurationCtrl) || !_this.configurationCtrl.hasChanges) {
                return;
            }
            var newUrl = $location.url();
            event.preventDefault();
            $modal
                .open({
                templateUrl: 'ng1/dist/src/Common/Components/YesNoCancelModal.html',
                controller: 'yesNoCancelModalCtrl',
                windowClass: 'app-modal-window',
                backdrop: 'static',
                resolve: {
                    header: function () {
                        return language.getElementValue('appSettingsHdr');
                    },
                    body: function () {
                        return language.getElementValue('saveChangesQuestionHdr');
                    }
                }
            })
                .result.then(function (data) {
                if (data === 'ok') {
                    _this.configurationCtrl.saveConfiguration().then(function () {
                        _this.configurationCtrl.hasChanges = false;
                        $location.url(newUrl);
                    });
                }
                if (data === 'no') {
                    _this.configurationCtrl.hasChanges = false;
                    $location.url(newUrl);
                }
            }, function () { });
        });
    }
    AdministrationCtrl.prototype.isAppConfigurationGroupActive = function () {
        var _this = this;
        return _.any(this.configurationTabs, function (tab) { return tab.name == _this.selectedTab.name; });
    };
    AdministrationCtrl.$inject = [
        '$scope',
        '$modal',
        '$location',
        '$routeParams',
        'authentication',
        'permissionService',
        'diagnosticService',
        'language',
    ];
    return AdministrationCtrl;
}());
angular.module('kamhpp').controller('AdministrationCtrl', AdministrationCtrl);
