var UserSettingsModalCtrl = (function () {
    function UserSettingsModalCtrl($scope, $modal, $modalInstance, guid, userProvider, language, notificationService, authenticationConfigurationProvider, user, users, roles) {
        var _this = this;
        var _a;
        this.$scope = $scope;
        this.$modal = $modal;
        this.$modalInstance = $modalInstance;
        this.guid = guid;
        this.userProvider = userProvider;
        this.language = language;
        this.notificationService = notificationService;
        this.authenticationConfigurationProvider = authenticationConfigurationProvider;
        this.user = user;
        this.users = users;
        this.roles = roles;
        this.newPasswordConfirm = '';
        this.image = { files: [] };
        this.authenticationTypes = [
            new UiSelectItem(0, this.language.getElementValue('securityInternalMsg')),
            new UiSelectItem(1, this.language.getElementValue('securityDomainMsg')),
            new UiSelectItem(2, this.language.getElementValue('securityLdapMsg')),
            new UiSelectItem(3, this.language.getElementValue('securityCtaMsg')),
        ];
        this.availableAuthenticationTypes = [];
        this.selectableAuthenticationTypes = [];
        this.selectedAuthenticationTypes = [];
        $scope.ctrl = this;
        this.isCreateOperation = _.isUndefined(user);
        if (this.isCreateOperation) {
            this.newUser = {
                id: guid.new(),
                authenticationTypes: [
                    {
                        login: '',
                        password: '',
                        type: 0,
                        isEnabled: true,
                        id: guid.new(),
                    }
                ],
                isActive: true,
                name: '',
                permissions: [],
                position: '',
                roles: [],
                signature: undefined,
                isMoreInfoOpened: false,
                isSystem: false,
                inlineRoleNames: '',
                signatureImage: undefined
            };
            this.isEditingPassword = true;
        }
        else {
            this.newUser = _.deepclone(user);
        }
        this.userRoles = _.filter(roles, function (role) { return _.contains(_this.newUser.roles, role.id); });
        this.authenticationConfigurationProvider.getEnabledAuthenticationTypes().then(function (types) {
            _this.availableAuthenticationTypes = _.filter(_this.authenticationTypes, function (authType) { return _.any(types, function (t) { return t === authType.ident; }); });
            _this.updateSelectableAuthenticationTypes();
        });
        this.initialInternalAuthId = (_a = this.newUser.authenticationTypes.find(function (authType) { return authType.type === 0; })) === null || _a === void 0 ? void 0 : _a.id;
        this.showImage();
    }
    UserSettingsModalCtrl.prototype.showImage = function () {
        if (this.newUser.signature) {
            this.newUser.signatureImage = 'data:image/png;base64,' + this.newUser.signature;
        }
        this.isImageSizeInvalid = false;
    };
    UserSettingsModalCtrl.prototype.updateSelectableAuthenticationTypes = function () {
        var _this = this;
        this.selectedAuthenticationTypes = _.map(this.newUser.authenticationTypes, function (at) { return _.find(_this.authenticationTypes, function (authType) { return authType.ident === at.type; }); });
        this.selectableAuthenticationTypes = _.filter(this.availableAuthenticationTypes, function (authType) { return _.all(_this.selectedAuthenticationTypes, function (at) { return at.ident !== authType.ident; }); });
    };
    UserSettingsModalCtrl.prototype.isAuthenticationTypeAvailable = function (type) {
        return _.any(this.availableAuthenticationTypes, function (authType) { return authType.ident === type; });
    };
    UserSettingsModalCtrl.prototype.canAddAuthenticationType = function () {
        var _a;
        return !((_a = this.user) === null || _a === void 0 ? void 0 : _a.isSystem) && this.selectableAuthenticationTypes.length > 0;
    };
    UserSettingsModalCtrl.prototype.addAuthenticationType = function () {
        var newAuthenticationType = this.selectableAuthenticationTypes[0];
        this.selectedAuthenticationTypes.push(this.selectableAuthenticationTypes[0]);
        this.newUser.authenticationTypes.push({
            id: this.guid.new(),
            login: '',
            password: '',
            type: newAuthenticationType.ident,
            isEnabled: true
        });
        this.updateSelectableAuthenticationTypes();
    };
    UserSettingsModalCtrl.prototype.removeAuthenticationType = function (index) {
        this.newUser.authenticationTypes.splice(index, 1);
        this.selectedAuthenticationTypes.splice(index, 1);
        this.updateSelectableAuthenticationTypes();
    };
    UserSettingsModalCtrl.prototype.setAuthType = function (index) {
        this.newUser.authenticationTypes[index].type = this.selectedAuthenticationTypes[index].ident;
        this.updateSelectableAuthenticationTypes();
    };
    UserSettingsModalCtrl.prototype.setRole = function (role, index) {
        this.userRoles[index] = role;
    };
    UserSettingsModalCtrl.prototype.removeRole = function (index) {
        this.userRoles.splice(index, 1);
    };
    UserSettingsModalCtrl.prototype.addRole = function () {
        this.userRoles.push(undefined);
    };
    UserSettingsModalCtrl.prototype.getAvailableRolesLeft = function () {
        var _this = this;
        return _.filter(this.roles, function (role) { return !_.any(_this.userRoles, function (userRole) { return (userRole === null || userRole === void 0 ? void 0 : userRole.id) === role.id; }); });
    };
    UserSettingsModalCtrl.prototype.uploadSignature = function (file) {
        var _this = this;
        if (!file) {
            return;
        }
        if (this.image.files.length === 0) {
            this.isImageSizeInvalid = false;
            return;
        }
        var fileReader = new FileReader();
        fileReader.readAsDataURL(file);
        fileReader.onload = function (e) {
            var imageSource = e.target.result;
            var image = new Image();
            image.src = imageSource;
            image.onload = function () {
                _this.$scope.$apply(function () {
                    _this.isImageSizeInvalid = !((image.naturalWidth <= 150 && image.naturalHeight <= 75) ||
                        (image.naturalHeight <= 150 && image.naturalWidth <= 75));
                    if (!_this.isImageSizeInvalid) {
                        _this.newUser.signatureImage = imageSource;
                        _this.newUser.signature = imageSource.split(',')[1];
                        _this.showImage();
                    }
                });
            };
        };
    };
    UserSettingsModalCtrl.prototype.removeSignature = function () {
        this.newUser.signature = undefined;
        this.newUser.signatureImage = undefined;
        this.isImageSizeInvalid = false;
        this.image.files = [];
    };
    UserSettingsModalCtrl.prototype.insertDomainUserInfo = function () {
        var _this = this;
        var modalInstance = this.$modal.open({
            templateUrl: 'ng1/dist/src/Administration/Security/Users/DomainUserModal/DomainUserModal.html',
            windowClass: 'app-modal-window',
            controller: 'DomainUserModalCtrl',
            backdrop: 'static',
            resolve: {
                domainUsers: function () {
                    return _.compact(_.map(_this.users, function (user) {
                        return _.find(user.authenticationTypes, function (userAuthType) { return userAuthType.type === 1; });
                    }));
                },
                language: function () {
                    return _this.language;
                }
            }
        });
        modalInstance.result.then(function (domainUser) {
            var userAuthDomain = _this.newUser.authenticationTypes.find(function (userAuth) { return userAuth.type === 1; });
            if (_.isEmpty(_this.newUser.name)) {
                _this.newUser.name = domainUser.name;
            }
            userAuthDomain.login = domainUser.login;
            userAuthDomain.password = domainUser.login;
        }, function () { });
    };
    UserSettingsModalCtrl.prototype.isAdsiAuthType = function (userAuthType) {
        return userAuthType.type === 1;
    };
    UserSettingsModalCtrl.prototype.isInternalUser = function (userAuthType) {
        return userAuthType.type === 0;
    };
    UserSettingsModalCtrl.prototype.changePassword = function (userAuthenticationTypeId) {
        var _this = this;
        this.userProvider.updatePassword({ userAuthenticationTypeId: userAuthenticationTypeId, name: this.newUser.name, password: this.newPasswordConfirm }).then(function () {
            _this.notificationService.showMessage(_this.language.getElementValue('userChangePasswordSuccessMsg')),
                _this.isEditingPassword = false;
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    UserSettingsModalCtrl.prototype.isConfirmChangePasswordAvailable = function (password) {
        return password.length > 0 && password === this.newPasswordConfirm;
    };
    UserSettingsModalCtrl.prototype.isOkButtonAvailable = function () {
        var _this = this;
        return _.isDefined(this.newUser)
            && this.newUser.name.length > 0
            && _.all(this.newUser.authenticationTypes, function (authType) {
                return authType.login && authType.login.length > 0
                    && (!_this.isEditingPassword
                        || authType.password === _this.newPasswordConfirm
                        || (authType.type !== 0));
            });
    };
    UserSettingsModalCtrl.prototype.ok = function () {
        var _this = this;
        this.userProvider.getAll().then(function (users) {
            var otherUserAuthTypes = _.flatten(_.map(_.filter(users, function (user) { return user.id !== _this.newUser.id; }), function (user) { return user.authenticationTypes; }));
            var _loop_1 = function (newUserAuthType) {
                var existingUserAuthType = _.find(otherUserAuthTypes, function (authType) { return newUserAuthType.type === authType.type && newUserAuthType.login === authType.login; });
                if (_.isDefined(existingUserAuthType)) {
                    _this.notificationService.warnMessage(String.Format(_this.language.getElementValue('securityUserExistsMsg'), existingUserAuthType.login));
                    return { value: void 0 };
                }
            };
            for (var _i = 0, _a = _this.newUser.authenticationTypes; _i < _a.length; _i++) {
                var newUserAuthType = _a[_i];
                var state_1 = _loop_1(newUserAuthType);
                if (typeof state_1 === "object")
                    return state_1.value;
            }
            _this.newUser.roles = _.map(_.filter(_this.userRoles, function (userRole) { return _.isDefined(userRole); }), function (userRole) { return userRole.id; });
            if (_this.newUser.roles.length == 0) {
                _this.notificationService.warnMessage(_this.language.getElementValue('userHasNoRolesMsg'));
            }
            _this.$modalInstance.close(_this.newUser);
        });
    };
    UserSettingsModalCtrl.prototype.cancel = function () {
        this.$modalInstance.dismiss();
    };
    UserSettingsModalCtrl.$inject = [
        '$scope',
        '$modal',
        '$modalInstance',
        'guid',
        'userProvider',
        'language',
        'notificationService',
        'authenticationConfigurationProvider',
        'user',
        'users',
        'roles',
    ];
    return UserSettingsModalCtrl;
}());
angular.module('kamhpp').controller('UserSettingsModalCtrl', UserSettingsModalCtrl);
