var DiagnosticService = (function () {
    function DiagnosticService($interval, appDiagnosticProvider, language) {
        var _this = this;
        this.appDiagnosticProvider = appDiagnosticProvider;
        this.language = language;
        this.RefreshIntervalMilliseconds = 10 * 60 * 1000;
        this.MillisecondsInDay = 1000 * 60 * 60 * 24;
        this.refresh();
        $interval(function () { return _this.refresh(); }, this.RefreshIntervalMilliseconds);
    }
    DiagnosticService.prototype.hasAppProblems = function () {
        if (_.isUndefined(this.appWarningInfo)) {
            return false;
        }
        return (this.appWarningInfo.hasMailErrors ||
            this.appWarningInfo.isServerUnavailable ||
            this.appWarningInfo.isFreeDriveSpaceOut ||
            this.appWarningInfo.isDatabaseUnavailable ||
            this.appWarningInfo.isStandbyDatabaseUsed ||
            this.appWarningInfo.isJobSchedulerDisabled ||
            this.appWarningInfo.isPeriodicJobFailed ||
            this.appWarningInfo.isLicenseExpiring ||
            _.isDefined(this.appWarningInfo.licenseGracePeriodEnd));
    };
    DiagnosticService.prototype.getAppWarningMessages = function () {
        if (_.isUndefined(this.appWarningInfo)) {
            return undefined;
        }
        var appWarningMessages = [];
        if (this.appWarningInfo.hasMailErrors) {
            appWarningMessages.push(this.language.getElementValue('diagnosticIsSomeMailsFailedHdr'));
        }
        if (this.appWarningInfo.isServerUnavailable) {
            appWarningMessages.push(this.language.getElementValue('diagnosticIsSomeServersUnavailableHdr'));
        }
        if (this.appWarningInfo.isFreeDriveSpaceOut) {
            appWarningMessages.push(this.language.getElementValue('diagnosticIsLowFreeDriveSpaceHdr'));
        }
        if (this.appWarningInfo.isDatabaseUnavailable) {
            appWarningMessages.push(this.language.getElementValue('diagnosticIsSomeDatabasesUnavailableHdr'));
        }
        if (this.appWarningInfo.isStandbyDatabaseUsed) {
            appWarningMessages.push(this.language.getElementValue('diagnosticIsStandbyDatabaseActiveHdr'));
        }
        if (this.appWarningInfo.isJobSchedulerDisabled) {
            appWarningMessages.push(this.language.getElementValue('diagnosticIsJobSchedulerDisabledHdr'));
        }
        if (this.appWarningInfo.isPeriodicJobFailed) {
            appWarningMessages.push(this.language.getElementValue('diagnosticIsSomePeriodicJobsFailedHdr'));
        }
        if (this.appWarningInfo.isLicenseExpiring) {
            appWarningMessages.push(this.language.getElementValue('diagnosticIsLicenseCloseToExpireHdr'));
        }
        if (_.isDefined(this.appWarningInfo.licenseGracePeriodEnd)) {
            appWarningMessages.push(this.language.getElementValue('diagnosticIsLicenseGracePeriodMsg'));
        }
        return appWarningMessages.join('\n');
    };
    DiagnosticService.prototype.refresh = function () {
        var _this = this;
        this.appDiagnosticProvider
            .getAppHealth()
            .then(function (appWarningInfo) {
            _this.appWarningInfo = appWarningInfo;
        });
    };
    DiagnosticService.$inject = [
        '$interval',
        'appDiagnosticProvider',
        'language'
    ];
    return DiagnosticService;
}());
angular.module('kamhpp').service('diagnosticService', DiagnosticService);
