var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ReportConfigurationCtrl = (function (_super) {
    __extends(ReportConfigurationCtrl, _super);
    function ReportConfigurationCtrl($scope, reportConfigurationProvider, notificationService, language) {
        var _this = _super.call(this, $scope) || this;
        _this.$scope = $scope;
        _this.reportConfigurationProvider = reportConfigurationProvider;
        _this.notificationService = notificationService;
        _this.language = language;
        _this.demoDataTypes = [
            new UiSelectItem(0, _this.language.getElementValue('reportDemoEmulationDoubleTypeHdr')),
            new UiSelectItem(1, _this.language.getElementValue('reportDemoEmulationIntegerTypeHdr')),
            new UiSelectItem(2, _this.language.getElementValue('reportDemoEmulationTextTypeHdr'))
        ];
        _this.ignoredActionTypes = [
            new UiSelectItem(5, _this.language.getElementValue('reportSettingsCreateReport')),
            new UiSelectItem(0, _this.language.getElementValue('reportSettingsRecalcReportData')),
            new UiSelectItem(3, _this.language.getElementValue('reportSettingsExportToFile')),
            new UiSelectItem(2, _this.language.getElementValue('reportSettingsSendToMail')),
            new UiSelectItem(4, _this.language.getElementValue('reportSettingsLockReport')),
        ];
        _this.selectedIgnoredActionTypes = [];
        _this.addWebHookAddress = function () {
            _this.configuration.saveWebHookAddresses.push('');
        };
        _this.loadConfiguration();
        return _this;
    }
    ;
    ;
    ReportConfigurationCtrl.prototype.onDemoDataTypeChanged = function (emulationValuesType) {
        this.configuration.emulationValuesType = emulationValuesType.ident;
        this.onConfigurationChanged();
    };
    ReportConfigurationCtrl.prototype.loadConfiguration = function () {
        var _this = this;
        this.reportConfigurationProvider
            .getReportConfiguration()
            .then(function (configuration) {
            _this.configuration = configuration;
            _this.selectedIgnoredActionTypes = _.filter(_this.ignoredActionTypes, function (type) { return _.any(configuration.ignoredActionTypes, function (t) { return t === type.ident; }); });
            _this.selectedDemoDataType = _.find(_this.demoDataTypes, function (type) { return type.ident === configuration.emulationValuesType; });
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    ReportConfigurationCtrl.prototype.saveConfiguration = function () {
        var _this = this;
        return this.reportConfigurationProvider
            .saveReportConfiguration(this.configuration)
            .then(function () {
            _this.hasChanges = false;
            _this.notificationService.showMessage(_this.language.getElementValue('changesSuccessSaveMsg'));
        })
            .catch(function (error) { return _this.notificationService.errorMessage(_this.language.getElementValue('failedSaveChangesMsg'), error); });
    };
    ;
    ReportConfigurationCtrl.prototype.onConfigurationChanged = function () {
        this.hasChanges = true;
    };
    ReportConfigurationCtrl.prototype.onIgnoredActionTypeSelected = function (providerType) {
        this.configuration.ignoredActionTypes.push(providerType.ident);
        this.onConfigurationChanged();
    };
    ReportConfigurationCtrl.prototype.onIgnoredActionTypeRemoved = function (providerType) {
        this.configuration.ignoredActionTypes = _.filter(this.configuration.ignoredActionTypes, function (type) { return type !== providerType.ident; });
        this.onConfigurationChanged();
    };
    ReportConfigurationCtrl.prototype.isTextDemoDataType = function () {
        return this.selectedDemoDataType.ident === 2;
    };
    ReportConfigurationCtrl.$inject = [
        '$scope',
        'reportConfigurationProvider',
        'notificationService',
        'language'
    ];
    return ReportConfigurationCtrl;
}(BaseConfigurationController));
angular
    .module('kamhpp')
    .controller('ReportConfigurationCtrl', ReportConfigurationCtrl);
