var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var MailConfigurationCtrl = (function (_super) {
    __extends(MailConfigurationCtrl, _super);
    function MailConfigurationCtrl($scope, mailProvider, notificationService, language) {
        var _this = _super.call(this, $scope) || this;
        _this.mailProvider = mailProvider;
        _this.notificationService = notificationService;
        _this.language = language;
        _this.loadConfiguration();
        return _this;
    }
    MailConfigurationCtrl.prototype.loadConfiguration = function () {
        var _this = this;
        this.mailProvider
            .getMailClientConfiguration()
            .then(function (coniguration) {
            _this.configuration = coniguration;
        })
            .catch(function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), data);
        });
    };
    MailConfigurationCtrl.prototype.saveConfiguration = function () {
        var _this = this;
        if (!this.isConfigurationValid()) {
            this.notificationService.warnMessage(this.language.getElementValue('allFieldsMustFilledMsg'));
            return;
        }
        return this.mailProvider
            .saveMailClientConfiguration(this.configuration)
            .then(function () {
            _this.hasChanges = false;
            _this.notificationService.showMessage(_this.language.getElementValue('changesSuccessSaveMsg'));
        })
            .catch(function (error) { return _this.notificationService.errorMessage(_this.language.getElementValue('failedSaveChangesMsg'), error); });
    };
    MailConfigurationCtrl.prototype.onConfigurationChanged = function () {
        this.hasChanges = true;
    };
    MailConfigurationCtrl.prototype.connectToServer = function () {
        var _this = this;
        if (_.isBlank(this.configuration.smtpHost)) {
            this.notificationService.warnMessage(this.language.getElementValue('serverSettingsServerAddressRequiredMsg'));
            return;
        }
        this.mailProvider
            .connectToServer(this.configuration.smtpHost, this.configuration.smtpPort)
            .then(function () { return _this.notificationService.showMessage(_this.language.getElementValue('connectionEstablishedMsg')); })
            .catch(function (error) { return _this.notificationService.errorMessage(_this.language.getElementValue('serverSettingsConnectionErrorMsg'), error); });
    };
    ;
    MailConfigurationCtrl.prototype.isConfigurationValid = function () {
        return !this.configuration.isEnable
            || !(_.isBlank(this.configuration.mailerAddress)
                || _.isBlank(this.configuration.mailerLogin)
                || _.isBlank(this.configuration.mailerPassword)
                || _.isBlank(this.configuration.smtpHost));
    };
    ;
    MailConfigurationCtrl.$inject = [
        '$scope',
        'mailProvider',
        'notificationService',
        'language'
    ];
    return MailConfigurationCtrl;
}(BaseConfigurationController));
angular
    .module('kamhpp')
    .controller('MailConfigurationCtrl', MailConfigurationCtrl);
