var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var AuthenticationConfigurationCtrl = (function (_super) {
    __extends(AuthenticationConfigurationCtrl, _super);
    function AuthenticationConfigurationCtrl($scope, guid, authenticationConfigurationProvider, notificationService, language) {
        var _this = _super.call(this, $scope) || this;
        _this.guid = guid;
        _this.authenticationConfigurationProvider = authenticationConfigurationProvider;
        _this.notificationService = notificationService;
        _this.language = language;
        _this.winccOaConnectionTypes = [4];
        _this.loadConfiguration();
        return _this;
    }
    AuthenticationConfigurationCtrl.prototype.loadConfiguration = function () {
        var _this = this;
        this.authenticationConfigurationProvider
            .getAuthenticationConfiguration()
            .then(function (authenticationConfiguration) { return _this.configuration = authenticationConfiguration; })
            .catch(function (error) { return _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error); });
    };
    AuthenticationConfigurationCtrl.prototype.saveConfiguration = function () {
        var _this = this;
        if (!this.isConfigurationValid()) {
            this.notificationService.warnMessage(this.language.getElementValue('allFieldsMustFilledMsg'));
            return;
        }
        return this.authenticationConfigurationProvider
            .saveAuthenticationConfiguration(this.configuration)
            .then(function () {
            _this.hasChanges = false;
            _this.notificationService.showMessage(_this.language.getElementValue('changesSuccessSaveMsg'));
        })
            .catch(function (error) { return _this.notificationService.errorMessage(_this.language.getElementValue('failedSaveChangesMsg'), error); });
    };
    AuthenticationConfigurationCtrl.prototype.onConfigurationChanged = function () {
        this.hasChanges = true;
    };
    AuthenticationConfigurationCtrl.prototype.refreshToken = function () {
        this.configuration.ctaConfiguration.token = this.guid.new('');
        this.onConfigurationChanged();
    };
    AuthenticationConfigurationCtrl.prototype.onTokenLifetimeValueChanged = function () {
        if (this.configuration.jwtConfiguration.accessTokenLifetimeInMinutes < 1) {
            this.configuration.jwtConfiguration.accessTokenLifetimeInMinutes = 1;
        }
        if (this.configuration.jwtConfiguration.refreshTokenLifetimeInDays < 1) {
            this.configuration.jwtConfiguration.refreshTokenLifetimeInDays = 1;
        }
        this.onConfigurationChanged();
    };
    AuthenticationConfigurationCtrl.prototype.isConfigurationValid = function () {
        return !(this.configuration.ldapConfiguration.isEnabled
            && (_.isBlank(this.configuration.ldapConfiguration.serverAddress)
                || _.isBlank(this.configuration.ldapConfiguration.userIdentifierFieldName)
                || _.isBlank(this.configuration.ldapConfiguration.userDirectoryPath)
                || _.isBlank(this.configuration.ldapConfiguration.userLoginFieldName)
                || _.isBlank(this.configuration.ldapConfiguration.userNameFieldName)
                || _.isBlank(this.configuration.ldapConfiguration.rootPassword)
                || _.isBlank(this.configuration.ldapConfiguration.rootLogin)));
    };
    AuthenticationConfigurationCtrl.$inject = [
        '$scope',
        'guid',
        'authenticationConfigurationProvider',
        'notificationService',
        'language'
    ];
    return AuthenticationConfigurationCtrl;
}(BaseConfigurationController));
angular
    .module('kamhpp')
    .controller('AuthenticationConfigurationCtrl', AuthenticationConfigurationCtrl);
