BEGIN TRANSACTION;

CREATE TABLE IF NOT EXISTS "__EFMigrationsHistory" (
    "MigrationId" TEXT NOT NULL CONSTRAINT "PK___EFMigrationsHistory" PRIMARY KEY,
    "ProductVersion" TEXT NOT NULL
);

CREATE TABLE "CimAttributeDataTypes" (
    "Id" INTEGER NOT NULL CONSTRAINT "PK_CimAttributeDataTypes" PRIMARY KEY AUTOINCREMENT,
    "Name" TEXT NOT NULL
);

CREATE TABLE "CimAttributeInstances" (
    "Id" INTEGER NOT NULL CONSTRAINT "PK_CimAttributeInstances" PRIMARY KEY AUTOINCREMENT,
    "UniqueCode" TEXT NOT NULL,
    "StartDate" TEXT NOT NULL,
    "EndDate" TEXT NULL,
    "AttributeUniqueCode" TEXT NULL,
    "ClassIstanceUniqueCode" TEXT NULL,
    "Value" TEXT NULL
);

CREATE TABLE "CimClasses" (
    "Id" INTEGER NOT NULL CONSTRAINT "PK_CimClasses" PRIMARY KEY AUTOINCREMENT,
    "UniqueCode" TEXT NOT NULL,
    "StartDate" TEXT NOT NULL,
    "EndDate" TEXT NULL,
    "Name" TEXT NOT NULL,
    "BaseClassUniqueCode" TEXT NULL
);

CREATE TABLE "CimClassInstances" (
    "Id" INTEGER NOT NULL CONSTRAINT "PK_CimClassInstances" PRIMARY KEY AUTOINCREMENT,
    "UniqueCode" TEXT NOT NULL,
    "StartDate" TEXT NOT NULL,
    "EndDate" TEXT NULL,
    "Name" TEXT NOT NULL,
    "ClassUniqueCode" TEXT NOT NULL
);

CREATE TABLE "CimDictionaryProfileSets" (
    "Id" TEXT NOT NULL CONSTRAINT "PK_CimDictionaryProfileSets" PRIMARY KEY,
    "Name" TEXT NULL
);

CREATE TABLE "CimLinkCapacities" (
    "Id" INTEGER NOT NULL CONSTRAINT "PK_CimLinkCapacities" PRIMARY KEY AUTOINCREMENT,
    "Name" TEXT NOT NULL
);

CREATE TABLE "CimLinkInstances" (
    "Id" INTEGER NOT NULL CONSTRAINT "PK_CimLinkInstances" PRIMARY KEY AUTOINCREMENT,
    "UniqueCode" TEXT NOT NULL,
    "StartDate" TEXT NOT NULL,
    "EndDate" TEXT NULL,
    "LinkUniqueCode" TEXT NULL,
    "SourceClassInstanceUniqueCode" TEXT NOT NULL,
    "TargetClassInstanceUniqueCode" TEXT NOT NULL
);

CREATE TABLE "CimLinkTypes" (
    "Id" INTEGER NOT NULL CONSTRAINT "PK_CimLinkTypes" PRIMARY KEY AUTOINCREMENT,
    "Name" TEXT NOT NULL
);

CREATE TABLE "CimAttributes" (
    "Id" INTEGER NOT NULL CONSTRAINT "PK_CimAttributes" PRIMARY KEY AUTOINCREMENT,
    "UniqueCode" TEXT NOT NULL,
    "StartDate" TEXT NOT NULL,
    "EndDate" TEXT NULL,
    "Name" TEXT NOT NULL,
    "ClassUniqueCode" TEXT NOT NULL,
    "DataTypeId" INTEGER NOT NULL,
    CONSTRAINT "FK_CimAttributes_CimAttributeDataTypes_DataTypeId" FOREIGN KEY ("DataTypeId") REFERENCES "CimAttributeDataTypes" ("Id") ON DELETE CASCADE
);

CREATE TABLE "CimDictionaryProfiles" (
    "Id" TEXT NOT NULL CONSTRAINT "PK_CimDictionaryProfiles" PRIMARY KEY,
    "SourceUniqueCode" TEXT NULL,
    "TargetUniqueCode" TEXT NULL,
    "LinkUniqueCode" TEXT NULL,
    "Name" TEXT NULL,
    "IsBackLink" INTEGER NOT NULL,
    "CreateGroupNode" INTEGER NOT NULL,
    "ShowRecursiveSelfLinks" INTEGER NOT NULL,
    "ParentId" TEXT NULL,
    "CimDictionaryProfileId" TEXT NOT NULL,
    "CimDictionaryProfileSetId" TEXT NOT NULL,
    CONSTRAINT "FK_CimDictionaryProfiles_CimDictionaryProfiles_CimDictionaryProfileId" FOREIGN KEY ("CimDictionaryProfileId") REFERENCES "CimDictionaryProfiles" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_CimDictionaryProfiles_CimDictionaryProfileSets_CimDictionaryProfileSetId" FOREIGN KEY ("CimDictionaryProfileSetId") REFERENCES "CimDictionaryProfileSets" ("Id") ON DELETE CASCADE
);

CREATE TABLE "CimLinks" (
    "Id" INTEGER NOT NULL CONSTRAINT "PK_CimLinks" PRIMARY KEY AUTOINCREMENT,
    "UniqueCode" TEXT NOT NULL,
    "StartDate" TEXT NOT NULL,
    "EndDate" TEXT NULL,
    "Name" TEXT NOT NULL,
    "SourceClassUniqueCode" TEXT NOT NULL,
    "TargetClassUniqueCode" TEXT NOT NULL,
    "TypeId" INTEGER NOT NULL,
    "CapacityId" INTEGER NOT NULL,
    CONSTRAINT "FK_CimLinks_CimLinkCapacities_CapacityId" FOREIGN KEY ("CapacityId") REFERENCES "CimLinkCapacities" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_CimLinks_CimLinkTypes_TypeId" FOREIGN KEY ("TypeId") REFERENCES "CimLinkTypes" ("Id") ON DELETE CASCADE
);

CREATE TABLE "ExternalConnectionSettings" (
    "Id" TEXT NOT NULL CONSTRAINT "PK_ExternalConnectionSettings" PRIMARY KEY,
    "Name" TEXT NOT NULL,
    "Type" INTEGER NOT NULL,
    "Status" INTEGER NOT NULL,
    "AllowableAccessErrorCount" INTEGER NOT NULL,
    "CurrentAccessErrorCount" INTEGER NOT NULL,
    "Json" TEXT NOT NULL,
    "LastCheckTime" TEXT NOT NULL,
    "ReconnectionInterval" TEXT NOT NULL
);

CREATE TABLE "Mails" (
    "Id" TEXT NOT NULL CONSTRAINT "PK_Mails" PRIMARY KEY,
    "CreationTimestamp" TEXT NOT NULL,
    "Message" BLOB NOT NULL,
    "IsSent" INTEGER NOT NULL
);

CREATE TABLE "OpcConnections" (
    "Id" INTEGER NOT NULL CONSTRAINT "PK_OpcConnections" PRIMARY KEY AUTOINCREMENT,
    "Name" TEXT NOT NULL,
    "Json" TEXT NOT NULL
);

CREATE TABLE "ReportTemplates" (
    "Id" INTEGER NOT NULL CONSTRAINT "PK_ReportTemplates" PRIMARY KEY AUTOINCREMENT,
    "UniqueGuid" TEXT NOT NULL,
    "Version" INTEGER NOT NULL,
    "Name" TEXT NOT NULL,
    "Chapter" TEXT NOT NULL,
    "Parameters" TEXT NOT NULL,
    "Html" TEXT NOT NULL,
    "Rules" TEXT NOT NULL,
    "ContentVersion" INTEGER NOT NULL,
    "HasStep" INTEGER NOT NULL,
    "IsHide" INTEGER NOT NULL,
    "PeriodStep" TEXT NULL,
    "Priority" INTEGER NOT NULL,
    "ReportType" INTEGER NOT NULL
);

CREATE TABLE "Reports" (
    "Id" INTEGER NOT NULL CONSTRAINT "PK_Reports" PRIMARY KEY AUTOINCREMENT,
    "Name" TEXT NOT NULL,
    "StartDate" TEXT NOT NULL,
    "EndDate" TEXT NOT NULL,
    "Values" BLOB NULL,
    "RecalculationState" INTEGER NOT NULL,
    "CalculationResult" INTEGER NOT NULL,
    "IsCompleted" INTEGER NOT NULL,
    "HasIncompletedRules" INTEGER NOT NULL,
    "ReportTemplateUniqueGuid" TEXT NOT NULL,
    "PredefinedValuesHashCode" INTEGER NOT NULL,
    "UpdatedDate" TEXT NOT NULL,
    "ReportTemplateId" INTEGER NOT NULL,
    "ContentVersion" INTEGER NOT NULL,
    "Changes" TEXT NULL,
    "CreatedDate" TEXT NOT NULL,
    "CreatedUserName" TEXT NULL,
    "DependentReports" TEXT NULL,
    "LockDate" TEXT NULL,
    "PredefinedValues" TEXT NOT NULL,
    "Rules" TEXT NULL,
    CONSTRAINT "FK_Reports_ReportTemplates_ReportTemplateId" FOREIGN KEY ("ReportTemplateId") REFERENCES "ReportTemplates" ("Id") ON DELETE CASCADE
);

CREATE TABLE "ServerSettings" (
    "Name" TEXT NOT NULL CONSTRAINT "PK_ServerSettings" PRIMARY KEY,
    "Value" TEXT NULL
);

CREATE TABLE "SysLogs" (
    "Id" BLOB NOT NULL CONSTRAINT "PK_SysLogs" PRIMARY KEY,
    "ActionTime" TEXT NOT NULL,
    "User" TEXT NOT NULL,
    "Description" TEXT NOT NULL,
    "TagValues" TEXT NOT NULL
);

CREATE TABLE "Users" (
    "Id" TEXT NOT NULL CONSTRAINT "PK_Users" PRIMARY KEY,
    "Login" TEXT NOT NULL,
    "Name" TEXT NOT NULL,
    "Password" TEXT NOT NULL,
    "IsActive" INTEGER NOT NULL,
	"IsDomain" INTEGER NOT NULL,
    "Position" TEXT NULL,
    "Signature" BLOB NULL,
    "SigningAuthority" TEXT NULL
);

CREATE TABLE "Roles" (
    "Id" TEXT NOT NULL CONSTRAINT "PK_Roles" PRIMARY KEY,
    "Name" TEXT NOT NULL,
    "PermissionIdents" TEXT NOT NULL,
    "IsDomainUserGroup" INTEGER NOT NULL
);

CREATE TABLE "UserRoles" (
    "UserId" TEXT NOT NULL,
    "RoleId" TEXT NOT NULL,
    CONSTRAINT "PK_UserRoles" PRIMARY KEY ("UserId", "RoleId"),
    CONSTRAINT "FK_UserRoles_Roles_RoleId" FOREIGN KEY ("RoleId") REFERENCES "Roles" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_UserRoles_Users_UserId" FOREIGN KEY ("UserId") REFERENCES "Users" ("Id") ON DELETE CASCADE
);

CREATE INDEX "IX_CimAttributes_DataTypeId" ON "CimAttributes" ("DataTypeId");

CREATE INDEX "IX_CimDictionaryProfiles_CimDictionaryProfileId" ON "CimDictionaryProfiles" ("CimDictionaryProfileId");

CREATE INDEX "IX_CimDictionaryProfiles_CimDictionaryProfileSetId" ON "CimDictionaryProfiles" ("CimDictionaryProfileSetId");

CREATE INDEX "IX_CimLinks_CapacityId" ON "CimLinks" ("CapacityId");

CREATE INDEX "IX_CimLinks_TypeId" ON "CimLinks" ("TypeId");

CREATE INDEX "IX_Reports_ReportTemplateId" ON "Reports" ("ReportTemplateId");

CREATE UNIQUE INDEX "IX_Reports_ReportTemplateId_StartDate_EndDate" ON "Reports" ("ReportTemplateId", "StartDate", "EndDate", "PredefinedValuesHashCode");

CREATE UNIQUE INDEX "IX_Reports_ReportTemplateUniqueGuid_StartDate_EndDate" ON "Reports" ("ReportTemplateUniqueGuid", "StartDate", "EndDate", "PredefinedValuesHashCode");

CREATE INDEX "IX_UserRoles_RoleId" ON "UserRoles" ("RoleId");

CREATE INDEX "IX_UserRoles_UserId" ON "UserRoles" ("UserId");

COMMIT;