START TRANSACTION;

DROP TABLE "WinCCOATreeElements";

CREATE TABLE "WinCCOATreeElements" (
    "Id" integer GENERATED BY DEFAULT AS IDENTITY,
    "Name" text NOT NULL,
    "Description" text NOT NULL,
    "ParentId" integer NULL,
    "ElementType" integer NOT NULL,
    "HasChildren" boolean NOT NULL,
    "FullName"	text,
	"ConnectionIdent"	uuid NOT NULL,
    CONSTRAINT "PK_WinCCOATreeElements" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_WinCCOATreeElements_WinCCOATreeElements_ParentId" FOREIGN KEY ("ParentId") REFERENCES "WinCCOATreeElements" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_WinCCOATreeElements_ExternalConnection_ConnectionIdent" FOREIGN KEY("ConnectionIdent") REFERENCES "ExternalConnectionSettings"("Id") ON DELETE CASCADE
);

CREATE INDEX "IX_WinCCOATreeElements_ParentId" ON "WinCCOATreeElements" ("ParentId");

COMMIT;