﻿START TRANSACTION;

CREATE TABLE "td"."OTParameters" (
    "Id" uuid NOT NULL,
    "Name" text NOT NULL,
    "Algorithm" text NOT NULL,
    CONSTRAINT "PK_OTParameters" PRIMARY KEY ("Id")
);

CREATE TABLE "td"."OTSettings" (
    "Name" text NOT NULL,
    "Value" text NULL,
    CONSTRAINT "PK_OTSettings" PRIMARY KEY ("Name")
);

CREATE TABLE "td"."OTAlgorithmConstants" (
    "Id" uuid NOT NULL,
    "Name" text NOT NULL,
    "ParameterId" uuid NOT NULL,
    CONSTRAINT "PK_OTAlgorithmConstants" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_OTAlgorithmConstants_OTParameters_ParameterId" FOREIGN KEY ("ParameterId") REFERENCES "td"."OTParameters" ("Id") ON DELETE CASCADE
);

CREATE TABLE "td"."OTAlgorithmParameters" (
    "Id" uuid NOT NULL,
    "Name" text NOT NULL,
    "ParameterId" uuid NOT NULL,
    CONSTRAINT "PK_OTAlgorithmParameters" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_OTAlgorithmParameters_OTParameters_ParameterId" FOREIGN KEY ("ParameterId") REFERENCES "td"."OTParameters" ("Id") ON DELETE CASCADE
);

CREATE TABLE "td"."OTDevices" (
    "Id" uuid NOT NULL,
    "Name" text NOT NULL,
    "ParameterId" uuid NOT NULL,
    CONSTRAINT "PK_OTDevices" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_OTDevices_OTParameters_ParameterId" FOREIGN KEY ("ParameterId") REFERENCES "td"."OTParameters" ("Id") ON DELETE CASCADE
);

CREATE TABLE "td"."OTParameterStates" (
    "Id" uuid NOT NULL,
    "Name" text NOT NULL,
    "ParameterId" uuid NOT NULL,
    "Value" integer NOT NULL,
    "LineType" integer NOT NULL,
    "BackgroundColor" integer NOT NULL,
    CONSTRAINT "PK_OTParameterStates" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_OTParameterStates_OTParameters_ParameterId" FOREIGN KEY ("ParameterId") REFERENCES "td"."OTParameters" ("Id") ON DELETE CASCADE
);

CREATE TABLE "td"."OTAlgorithmConstantCrosses" (
    "Id" uuid NOT NULL,
    "AlgorithmConstantId" uuid NOT NULL,
    "DeviceId" uuid NOT NULL,
    "Value" double precision NOT NULL,
    CONSTRAINT "PK_OTAlgorithmConstantCrosses" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_OTAlgorithmConstantCrosses_OTAlgorithmConstants_AlgorithmCo~" FOREIGN KEY ("AlgorithmConstantId") REFERENCES "td"."OTAlgorithmConstants" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_OTAlgorithmConstantCrosses_OTDevices_DeviceId" FOREIGN KEY ("DeviceId") REFERENCES "td"."OTDevices" ("Id") ON DELETE CASCADE
);

CREATE TABLE "td"."OTAlgorithmParameterCrosses" (
    "Id" uuid NOT NULL,
    "AlgorithmParameterId" uuid NOT NULL,
    "DeviceId" uuid NOT NULL,
    "Address" text NULL,
    CONSTRAINT "PK_OTAlgorithmParameterCrosses" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_OTAlgorithmParameterCrosses_OTAlgorithmParameters_Algorithm~" FOREIGN KEY ("AlgorithmParameterId") REFERENCES "td"."OTAlgorithmParameters" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_OTAlgorithmParameterCrosses_OTDevices_DeviceId" FOREIGN KEY ("DeviceId") REFERENCES "td"."OTDevices" ("Id") ON DELETE CASCADE
);

CREATE TABLE "td"."OTChanges" (
    "Id" integer NOT NULL GENERATED BY DEFAULT AS IDENTITY,
    "UserId" uuid NOT NULL,
    "ChangeTime" timestamp without time zone NOT NULL,
    "OldTimestamp" timestamp without time zone NULL,
    "NewTimestamp" timestamp without time zone NULL,
    "OldParameterStateId" uuid NULL,
    "NewParameterStateId" uuid NULL,
    "DeviceId" uuid NOT NULL,
    CONSTRAINT "PK_OTChanges" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_OTChanges_OTDevices_DeviceId" FOREIGN KEY ("DeviceId") REFERENCES "OTDevices" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_OTChanges_OTParameterStates_NewParameterStateId" FOREIGN KEY ("NewParameterStateId") REFERENCES "td"."OTParameterStates" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_OTChanges_OTParameterStates_OldParameterStateId" FOREIGN KEY ("OldParameterStateId") REFERENCES "td"."OTParameterStates" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_OTChanges_Users_UserId" FOREIGN KEY ("UserId") REFERENCES "Users" ("Id") ON DELETE CASCADE
);

CREATE TABLE "td"."OTRecords" (
    "Id" uuid NOT NULL,
    "StateId" uuid NOT NULL,
    "DeviceId" uuid NOT NULL,
    "CreatedTimeStamp" timestamp without time zone NOT NULL,
    "CreatedUserId" uuid NOT NULL,
    "TimeStamp" timestamp without time zone NOT NULL,
    CONSTRAINT "PK_OTRecords" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_OTRecords_OTDevices_DeviceId" FOREIGN KEY ("DeviceId") REFERENCES "td"."OTDevices" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_OTRecords_OTParameterStates_StateId" FOREIGN KEY ("StateId") REFERENCES "td"."OTParameterStates" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_OTRecords_Users_CreatedUserId" FOREIGN KEY ("CreatedUserId") REFERENCES "td"."Users" ("Id") ON DELETE CASCADE
);

CREATE INDEX "IX_OTAlgorithmConstantCrosses_AlgorithmConstantId" ON "td"."OTAlgorithmConstantCrosses" ("AlgorithmConstantId");

CREATE INDEX "IX_OTAlgorithmConstantCrosses_DeviceId" ON "td"."OTAlgorithmConstantCrosses" ("DeviceId");

CREATE INDEX "IX_OTAlgorithmConstants_ParameterId" ON "td"."OTAlgorithmConstants" ("ParameterId");

CREATE INDEX "IX_OTAlgorithmParameterCrosses_AlgorithmParameterId" ON "td"."OTAlgorithmParameterCrosses" ("AlgorithmParameterId");

CREATE INDEX "IX_OTAlgorithmParameterCrosses_DeviceId" ON "td"."OTAlgorithmParameterCrosses" ("DeviceId");

CREATE INDEX "IX_OTAlgorithmParameters_ParameterId" ON "td"."OTAlgorithmParameters" ("ParameterId");

CREATE INDEX "IX_OTChanges_DeviceId" ON "td"."OTChanges" ("DeviceId");

CREATE INDEX "IX_OTChanges_NewParameterStateId" ON "td"."OTChanges" ("NewParameterStateId");

CREATE INDEX "IX_OTChanges_OldParameterStateId" ON "td"."OTChanges" ("OldParameterStateId");

CREATE INDEX "IX_OTChanges_UserId" ON "td"."OTChanges" ("UserId");

CREATE INDEX "IX_OTDevices_ParameterId" ON "td"."OTDevices" ("ParameterId");

CREATE UNIQUE INDEX "IX_OTParameters_Name" ON "td"."OTParameters" ("Name");

CREATE INDEX "IX_OTParameterStates_ParameterId" ON "td"."OTParameterStates" ("ParameterId");

CREATE INDEX "IX_OTRecords_CreatedUserId" ON "td"."OTRecords" ("CreatedUserId");

CREATE UNIQUE INDEX "IX_OTRecords_DeviceId_TimeStamp" ON "td"."OTRecords" ("DeviceId", "TimeStamp");

CREATE INDEX "IX_OTRecords_StateId" ON "td"."OTRecords" ("StateId");

COMMIT;
