WITH RankedDevices AS (
    SELECT 
        "Id",
        "ParameterId",
        ROW_NUMBER() OVER (
            PARTITION BY "ParameterId"
            ORDER BY "Name" ASC
        ) - 1 AS "RowNum"
    FROM 
        "td"."OTDevices"
)

UPDATE "td"."OTDevices"
SET "Order" = RankedDevices."RowNum"
FROM RankedDevices
WHERE "td"."OTDevices"."Id" = RankedDevices."Id";
