CREATE TABLE [UserAuthenticationTypes] (
    [Id] uniqueidentifier PRIMARY KEY,
    [UserId] uniqueidentifier NOT NULL,
    [Login] NVARCHAR(255) NOT NULL,
    [Password] NVARCHAR(255),
    [Type] INT NOT NULL,
    [IsEnabled] BIT NOT NULL DEFAULT 1,
    CONSTRAINT [FK_UserAuthenticationTypes_Users_UserId] FOREIGN KEY ([UserId]) REFERENCES [Users]([Id]) ON DELETE CASCADE
);

INSERT INTO [UserAuthenticationTypes] ([Id], [UserId], [Login], [Password], [Type], [IsEnabled])
SELECT NEWID(), [Id], [Login], [Password], [AuthenticationType], 1
FROM [Users];

DROP INDEX [IX_Users_Login] ON [Users];

DECLARE @constraintName NVARCHAR(255);

SELECT TOP 1 @constraintName = dc.name
FROM sys.default_constraints dc
         JOIN sys.columns c
              ON c.object_id=dc.parent_object_id AND c.column_id=dc.parent_column_id
WHERE dc.parent_object_id=OBJECT_ID(N'dbo.Users') AND c.name=N'AuthenticationType';

IF @constraintName IS NOT NULL
    EXEC('ALTER TABLE dbo.Users DROP CONSTRAINT [' + @constraintName + ']');

CREATE UNIQUE INDEX [IX_UserAuthenticationTypes_Login_Type] ON [UserAuthenticationTypes] ([Login], [Type]);

ALTER TABLE [Users] DROP COLUMN [Login];
ALTER TABLE [Users] DROP COLUMN [Password];
ALTER TABLE [Users] DROP COLUMN [AuthenticationType];
ALTER TABLE [Users] DROP COLUMN [SigningAuthority];