-- In 016_AddReportViewModeToReportTemplate migration MSSQL creates a constraint that forbids to drop the ReportViewMode column --
DECLARE @ConstraintName NVARCHAR(128);
DECLARE @SQL NVARCHAR(MAX);

SELECT @ConstraintName = dc.name
FROM sys.default_constraints dc
JOIN sys.columns c ON dc.parent_object_id = c.object_id AND dc.parent_column_id = c.column_id
WHERE dc.parent_object_id = OBJECT_ID('ReportTemplates')
  AND c.name = 'ReportViewMode';

SET @SQL = '
    IF OBJECT_ID(''ReportTemplates'') IS NOT NULL
    BEGIN
        IF EXISTS (SELECT 1 FROM sys.default_constraints WHERE name = ''' + @ConstraintName + ''')
        BEGIN
            ALTER TABLE [ReportTemplates] DROP CONSTRAINT [' + @ConstraintName + '];
        END
        ALTER TABLE [ReportTemplates] DROP COLUMN [ReportViewMode];
    END
';

EXEC sp_executesql @SQL;